-- Maintenance on the ip_results table:
--  Delete duplicated records by removing the older one.
--  Delete duplicated records that have the same timestamp by 
--    removing one of them.
-- Note: it is (much) faster to add records to the ip_results table without primary keys
--       and then delete the duplicates than it is to add records via Update with primary keys.
-- Find duplicates and delete the older one:
DELETE FROM ip_results USING ip_results t2
  WHERE ip_results.bldgtype = t2.bldgtype
    AND ip_results.bldgvint = t2.bldgvint
    AND ip_results.bldgloc = t2.bldgloc
    AND ip_results.bldghvac = t2.bldghvac
    AND ip_results.tstat = t2.tstat
    AND ip_results.lastmod < t2.lastmod;
-- Find duplicates that have the same value for lastmod and delete one:
DELETE FROM ip_results 
    WHERE EXISTS
(SELECT 1 from ip_results t2 where 
       t2.bldgtype  = ip_results.bldgtype and
       t2.bldgvint  = ip_results.bldgvint and
       t2.bldgloc   = ip_results.bldgloc and
       t2.bldghvac  = ip_results.bldghvac and
       t2.tstat     = ip_results.tstat and
       t2.ctid > ip_results.ctid);